/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.smithing.feature;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import svenhjol.meson.Feature;

public class ExtractEnchantments
extends Feature {
    public static int baseCost;
    public static int weaken;

    @Override
    public String getDescription() {
        return "Extract enchantments from any enchanted item into an empty book.\nThe enchantments are weakened in the process, and the original item is destroyed.";
    }

    @Override
    public void configure() {
        super.configure();
        baseCost = this.propInt("Base XP cost", "The minimum XP cost before adding XP equivalent to the enchantment level(s) of the item.", 1);
        weaken = this.propInt("Weaken by amount", "Number of levels that enchantments are weakened when converting.", 1);
    }

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack in = event.getLeft();
        ItemStack combine = event.getRight();
        if (!in.func_190926_b() && !combine.func_190926_b() && combine.func_77973_b() == Items.field_151122_aG) {
            NBTTagList inTags = in.func_77986_q();
            NBTTagList combineTags = combine.func_77986_q();
            if (!inTags.func_82582_d() && combineTags.func_82582_d()) {
                int cost = baseCost;
                int numEnchantments = 0;
                Map inEnchants = EnchantmentHelper.func_82781_a((ItemStack)in);
                HashMap<Enchantment, Integer> outEnchants = new HashMap<Enchantment, Integer>();
                for (Map.Entry entry : inEnchants.entrySet()) {
                    int level;
                    int w;
                    Enchantment enchantment = (Enchantment)entry.getKey();
                    if (enchantment == null || (w = (level = ((Integer)entry.getValue()).intValue()) - weaken) <= 0) continue;
                    ++numEnchantments;
                    outEnchants.put(enchantment, w);
                    cost += w;
                }
                if (numEnchantments == 0) {
                    event.setCanceled(true);
                    return;
                }
                if (in.func_77978_p() != null && !in.func_77978_p().func_82582_d()) {
                    cost += in.func_77978_p().func_74762_e("RepairCost");
                }
                ItemStack out = new ItemStack(Items.field_151134_bR);
                EnchantmentHelper.func_82782_a(outEnchants, (ItemStack)out);
                String name = event.getName();
                if (!name.isEmpty()) {
                    out.func_151001_c(name);
                }
                event.setCost(cost);
                event.setMaterialCost(1);
                event.setOutput(out);
            }
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}

